/*******************************************************************
*
*  DESCRIPTION: auditor Model
*
*  AUTHOR: Shagun Goel
*
*
*  *
*******************************************************************/

#ifndef __auditor_H
#define __auditor_H

#include "atomic.h"     // class Atomic
#include "time.h"	// class Time
#include <list>

class auditor : public Atomic
{
public:
	auditor( const string &name = "auditor" );	//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &enter_sys;
	const Port &exit_q;
	const Port &exit_sys;
	const Port &in;
	Port &exp_custsys;
	Port &exp_custque;
	Port &wait_que;
	Port &wait_sys;
	int in_sys, out_q, out_sys;
	float exp_custsys_val, exp_custque_val, wait_que_val, wait_sys_val;
	void calculate_exp_custsys();
	void calculate_exp_custque(const Time &time);
	void calculate_wait_que();
	void calculate_wait_sys(const Time &time);
	typedef list<Time> TimeStamps;
	TimeStamps arrivalTimesexp_custque;  // Holds arrival times for customers in the queue
	TimeStamps arrivalTimeswait_sys;  // Holds arrival times for customers in the system
				    // but had already left the queue
	float convertTimeToSec(const Time &time);
};	// class auditor

// ** inline ** // 
inline
string auditor::className() const
{
return "auditor" ;
}
#endif   //__auditor_H
